/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer;

import at.redeye.FrameWork.base.BaseModuleLauncher;
import at.redeye.FrameWork.base.Root;
import at.redeye.FrameWork.base.Setup;
import com.auxilii.msgparser.Message;
import java.awt.Desktop;
import java.io.File;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.JOptionPane;
import net.sourceforge.MSGViewer.ModuleLauncher;
import net.sourceforge.MSGViewer.factory.MessageParserFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class CLIFileConverter {
    public static Logger logger = BaseModuleLauncher.logger;
    protected ModuleLauncher module_launcher;
    protected Root root;
    private final String sourceType;
    private final String targetType;
    private boolean convertToTemp = false;
    private boolean openAfterConvert = false;

    public CLIFileConverter(ModuleLauncher module_launcher, String sourceType, String targetType) {
        this.module_launcher = module_launcher;
        this.root = module_launcher.root;
        BaseModuleLauncher.BaseConfigureLogging((Level)Level.INFO);
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    public void setConvertToTemp(boolean convertToTemp) {
        this.convertToTemp = convertToTemp;
    }

    public void setOpenAfterConvert(boolean openAfterConvert) {
        this.openAfterConvert = openAfterConvert;
    }

    public abstract String getCLIParameter();

    public void usage() {
        System.out.println(this.root.MlM(MessageFormat.format("usage: {0} FILE FILE ....", this.getCLIParameter())));
    }

    public void work() {
        boolean converted = false;
        MessageParserFactory factory = new MessageParserFactory();
        for (String sourceFilePath : this.module_launcher.args) {
            if (!sourceFilePath.toLowerCase().endsWith(MessageFormat.format(".{0}", this.sourceType))) continue;
            converted = true;
            this.processFile(factory, sourceFilePath);
        }
        if (!converted) {
            this.usage();
        }
    }

    private void processFile(MessageParserFactory factory, String sourceFilePath) {
        File sourceFile = new File(sourceFilePath);
        String baseFileName = sourceFile.getName();
        int idx = baseFileName.lastIndexOf(".");
        baseFileName = baseFileName.substring(0, idx);
        logger.info((Object)MessageFormat.format("conversion source file: {0}", sourceFile));
        try {
            File targetFile;
            if (this.convertToTemp) {
                targetFile = File.createTempFile(baseFileName, MessageFormat.format(".{0}", this.targetType));
            } else {
                File targetDirectory = sourceFile.getParentFile();
                targetFile = Paths.get(targetDirectory.getAbsolutePath(), MessageFormat.format("{0}.{1}", baseFileName, this.targetType)).toFile();
            }
            logger.info((Object)MessageFormat.format("conversion target file: {0}", targetFile));
            Message msg = factory.parseMessage(sourceFile);
            factory.saveMessage(msg, targetFile);
            if (this.openAfterConvert) {
                this.openFile(targetFile);
            }
        }
        catch (Exception ex) {
            System.err.print(ex);
            ex.printStackTrace();
        }
    }

    public void openFile(File targetFile) {
        block9: {
            try {
                Desktop.getDesktop().open(targetFile);
            }
            catch (Exception e) {
                logger.warn((Object)"failed to open default application with Desktop.open(), trying system dependent command.");
                String[] cmdarray = null;
                if (Setup.is_linux_system()) {
                    cmdarray = new String[]{"xdg-open", targetFile.getAbsolutePath()};
                } else if (Setup.is_mac_system()) {
                    cmdarray = new String[]{"open", targetFile.getAbsolutePath()};
                } else if (Setup.is_win_system()) {
                    cmdarray = new String[]{"cmd", "/c", targetFile.getAbsolutePath()};
                }
                if (cmdarray == null) break block9;
                try {
                    Runtime.getRuntime().exec(cmdarray);
                }
                catch (Exception e1) {
                    String message = MessageFormat.format("Unable to open converted file.\nCould not execute command {0} \nwith parameters {1}", cmdarray[0], Arrays.asList(cmdarray).subList(1, cmdarray.length));
                    logger.error((Object)message.replaceAll("\n", ""));
                    JOptionPane.showMessageDialog(null, message, "Error opening converted file", 0);
                }
            }
        }
    }
}

