/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.CLIHelp;

import at.redeye.FrameWork.utilities.StringUtils;
import java.util.ArrayList;

public class CLIOption {
    private String name;
    private String short_description;
    private String long_description = null;

    public CLIOption(String name, String short_description, String long_description) {
        this.name = name;
        this.short_description = short_description;
        this.long_description = long_description;
    }

    public CLIOption(String name, String short_description) {
        this.name = name;
        this.short_description = short_description;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return this.short_description;
    }

    public String getLongDescription() {
        return this.long_description;
    }

    public void buildShortHelpText(StringBuilder sb, int fill_len_to_short_description, int max_line_len) {
        CLIOption.addWithFillSpacesTrailing(sb, this.name, fill_len_to_short_description);
        ArrayList<String> text = CLIOption.splitTextForMaximumLen(this.short_description, fill_len_to_short_description, max_line_len);
        for (int i = 0; i < text.size(); ++i) {
            String s = text.get(i);
            if (i == 0) {
                sb.append(s.substring(fill_len_to_short_description - 1));
                continue;
            }
            sb.append(s);
        }
    }

    public void buildLongHelpText(StringBuilder sb, int fill_len_to_short_description, int max_line_len) {
        if (this.long_description == null) {
            return;
        }
        ArrayList<String> text = CLIOption.splitTextForMaximumLen(this.long_description, fill_len_to_short_description, max_line_len);
        for (String s : text) {
            sb.append(s);
            sb.append("\n");
        }
    }

    public static void addWithFillSpacesTrailing(StringBuilder sb, String value, int len) {
        sb.append(value);
        for (int i = value.length(); i < len; ++i) {
            sb.append(" ");
        }
    }

    public static void addWithFillSpacesLeading(StringBuilder sb, String value, int len) {
        for (int i = value.length(); i < len; ++i) {
            sb.append(" ");
        }
        sb.append(value);
    }

    public static String addWithFillSpacesLeading(String value, int len) {
        StringBuilder sb = new StringBuilder();
        CLIOption.addWithFillSpacesLeading(sb, value, len);
        return sb.toString();
    }

    public static ArrayList<String> splitTextForMaximumLen(String descr, int fill_len_to_short_description, int max_line_len) {
        int max_len = max_line_len - fill_len_to_short_description;
        String breaked_text = StringUtils.autoLineBreak((String)descr, (int)max_len);
        String[] breaked_array = breaked_text.split("\n");
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : breaked_array) {
            ret.add(CLIOption.addWithFillSpacesLeading("", fill_len_to_short_description) + s);
        }
        return ret;
    }
}

