/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer;

import at.redeye.FrameWork.base.AutoLogger;
import at.redeye.FrameWork.base.BaseDialog;
import at.redeye.FrameWork.base.Root;
import com.auxilii.msgparser.Message;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sourceforge.MSGViewer.HtmlFromRtf;
import net.sourceforge.MSGViewer.rtfparser.ParseException;

public class Internals
extends BaseDialog {
    private String dialog_id;
    private Message message;
    private String MESSAGE_NOHTML_CODE;
    private String MESSAGE_UNPARSABLE_CODE;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTextArea jTHTML;
    private JTextArea jTHeader;
    private JTextArea jTPlain;
    private JTextArea jTRTF;
    private JTabbedPane jTabbedPane1;

    public Internals(Root root, final Message message) {
        super(root, root.MlM("Detail info") + ": " + (message.getSubject() != null ? message.getSubject() : root.getAppTitle()));
        this.initComponents();
        this.MESSAGE_NOHTML_CODE = this.MlM("This message does not contain HTML formatted code.");
        this.MESSAGE_UNPARSABLE_CODE = this.MlM("Cannot extract HTML formatted code from RTF coded message.");
        this.jTHeader.setText(message.getHeaders());
        this.jTHeader.setCaretPosition(0);
        this.jTPlain.setText(message.getBodyText());
        this.jTPlain.setCaretPosition(0);
        this.jTRTF.setText(message.getBodyRTF());
        this.jTRTF.setCaretPosition(0);
        if (message.getBodyRTF() != null && message.getBodyRTF().contains("\\fromhtml")) {
            AutoLogger al = new AutoLogger(Internals.class.getName()){

                public void do_stuff() throws Exception {
                    Internals.this.jTHTML.setText(Internals.this.extractHTMLFromRTF(message.getBodyRTF()));
                }
            };
            if (al.isFailed()) {
                this.jTHTML.setText(this.MESSAGE_UNPARSABLE_CODE);
            }
        } else if (message.getBodyRTF() != null && message.getBodyRTF().contains("\\purehtml")) {
            this.jTHTML.setText(message.getBodyRTF());
        } else {
            this.jTHTML.setText(this.MESSAGE_NOHTML_CODE);
        }
        this.jTHTML.setCaretPosition(0);
    }

    public String getUniqueDialogIdentifier(Object requester) {
        if (this.dialog_id == null) {
            this.dialog_id = super.getUniqueDialogIdentifier(requester);
        }
        return this.dialog_id;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTHeader = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.jTPlain = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.jTRTF = new JTextArea();
        this.jScrollPane4 = new JScrollPane();
        this.jTHTML = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.jTHeader.setColumns(20);
        this.jTHeader.setRows(5);
        this.jScrollPane1.setViewportView(this.jTHeader);
        this.jTabbedPane1.addTab("Mail Header", this.jScrollPane1);
        this.jTPlain.setColumns(20);
        this.jTPlain.setRows(5);
        this.jScrollPane2.setViewportView(this.jTPlain);
        this.jTabbedPane1.addTab("Message Text", this.jScrollPane2);
        this.jTRTF.setColumns(20);
        this.jTRTF.setRows(5);
        this.jScrollPane3.setViewportView(this.jTRTF);
        this.jTabbedPane1.addTab("RTF Code", this.jScrollPane3);
        this.jTHTML.setColumns(20);
        this.jTHTML.setRows(5);
        this.jScrollPane4.setViewportView(this.jTHTML);
        this.jTabbedPane1.addTab("HTML Code", this.jScrollPane4);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 651, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 444, Short.MAX_VALUE));
        this.pack();
    }

    private String extractHTMLFromRTF(String bodyText) throws ParseException {
        HtmlFromRtf rtf2html = new HtmlFromRtf(bodyText);
        return rtf2html.getHTML();
    }
}

