/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer;

import at.redeye.FrameWork.base.Setup;
import at.redeye.FrameWork.utilities.StringUtils;
import com.auxilii.msgparser.Message;
import com.auxilii.msgparser.attachment.Attachment;
import com.auxilii.msgparser.attachment.FileAttachment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.MSGViewer.ViewerHelper;
import org.apache.log4j.Logger;

public class PrepareImages {
    private static final Logger logger = Logger.getLogger((String)PrepareImages.class.getName());
    String base_dir;
    private final String extra;
    List<Attachment> attachments;

    public PrepareImages(String base_dir, Message message) {
        this.base_dir = base_dir;
        this.extra = Setup.is_linux_system() ? "/" : "";
        this.attachments = message.getAttachments();
    }

    private int findImgTag(StringBuilder s, int start) {
        Pattern pattern = Pattern.compile("<\\s*img", 2);
        Matcher matcher = pattern.matcher(s);
        while (matcher.find(start)) {
            int pos = matcher.start();
            if (s.length() <= pos + 3) {
                return -1;
            }
            if (StringUtils.is_space((char)s.charAt(pos + 4))) {
                return pos;
            }
            if (pos < s.length() - 1) continue;
        }
        return -1;
    }

    private String replace_src(StringBuilder s, List<FileAttachment> attached_images) {
        String[] res = s.toString().split("[sS][rR][cC]\\s*=");
        int i = 0;
        StringBuilder ret = new StringBuilder();
        for (String part : res) {
            if (++i == 1) {
                ret.append(part);
                continue;
            }
            ret.append("src=");
            int start = part.indexOf("\"");
            int end = -1;
            if (start >= 0) {
                end = part.indexOf("\"", start + 1);
            }
            String src = part;
            String rest = "";
            if (start >= 0 && end > 0) {
                src = part.substring(start + 1, end);
                if (end > 0) {
                    rest = part.substring(end + 1);
                }
            }
            String imgsrc = src;
            if (!src.toLowerCase().startsWith("http:") && !src.isEmpty()) {
                logger.info((Object)"HERE");
                imgsrc = "file:/" + this.extra + this.base_dir + "/" + src;
                File file = new File(this.extra + this.base_dir + "/" + src);
                if (!file.exists() && !attached_images.isEmpty()) {
                    if (src.toLowerCase().startsWith("cid:")) {
                        String cid = src.substring(4);
                        for (FileAttachment fatt : attached_images) {
                            if (fatt.getCid() == null || !fatt.getCid().equals(cid)) continue;
                            imgsrc = "file:/" + this.extra + this.base_dir + "/" + PrepareImages.getFileName(fatt);
                            attached_images.remove(fatt);
                            break;
                        }
                    } else {
                        imgsrc = "file:/" + this.extra + this.base_dir + "/" + PrepareImages.getFileName(attached_images.remove(0));
                    }
                }
            }
            logger.info((Object)("image: " + src));
            if (imgsrc == null) continue;
            ret.append("\"");
            ret.append(imgsrc);
            ret.append("\"");
            ret.append(rest);
        }
        return ret.toString();
    }

    static String getFileName(FileAttachment fatt) {
        if (fatt.getFilename() == null || fatt.getFilename().isEmpty()) {
            return fatt.getLongFilename();
        }
        return fatt.getFilename();
    }

    public StringBuilder prepareImages(StringBuilder s) {
        int end;
        int start = 0;
        ArrayList<FileAttachment> attached_images = new ArrayList<FileAttachment>();
        for (Attachment att : this.attachments) {
            if (!(att instanceof FileAttachment)) continue;
            FileAttachment fatt = (FileAttachment)att;
            String mime_type = fatt.getMimeTag();
            logger.info((Object)(fatt.toString() + " " + mime_type));
            if (mime_type == null || !ViewerHelper.is_image_mime_type(mime_type)) continue;
            attached_images.add(fatt);
        }
        Collections.sort(attached_images, new Comparator<FileAttachment>(){

            @Override
            public int compare(FileAttachment o1, FileAttachment o2) {
                if (o1.getSubDir() != null && o2.getSubDir() != null) {
                    return o1.getSubDir().compareTo(o2.getSubDir());
                }
                return o1.getFilename().compareTo(o2.getFilename());
            }
        });
        while ((start = this.findImgTag(s, start)) >= 0 && (end = s.indexOf(">", start)) >= 0) {
            String res = this.replace_src(new StringBuilder(s.subSequence(start, end)), attached_images);
            s.replace(start, end, res);
            if (res.length() == 0) {
                ++start;
                continue;
            }
            start += res.length();
        }
        return s;
    }
}

