/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer;

import at.redeye.FrameWork.Plugin.AboutPlugins;
import at.redeye.FrameWork.base.AutoMBox;
import at.redeye.FrameWork.base.BaseDialog;
import at.redeye.FrameWork.base.BaseDialogBase;
import at.redeye.FrameWork.base.Root;
import at.redeye.FrameWork.base.prm.impl.gui.LocalConfig;
import at.redeye.FrameWork.utilities.StringUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sourceforge.MSGViewer.About;
import net.sourceforge.MSGViewer.EditorDropTarget;
import net.sourceforge.MSGViewer.Internals;
import net.sourceforge.MSGViewer.LoadMessageInterface;
import net.sourceforge.MSGViewer.LocalHelpWin;
import net.sourceforge.MSGViewer.MSGFileFilter;
import net.sourceforge.MSGViewer.MSGNavigator.MSGNavigator;
import net.sourceforge.MSGViewer.MainDialog;
import net.sourceforge.MSGViewer.OpenNewMailInterface;
import net.sourceforge.MSGViewer.ViewerPanel;

public class SingleWin
extends BaseDialog
implements MainDialog,
OpenNewMailInterface,
LoadMessageInterface {
    private static String last_path = null;
    private String dialog_id;
    private JMenuItem jFileOpen;
    private JMenu jMFileOpen;
    private JMenuItem jMFileSave;
    private JMenuItem jMNav;
    private JMenuItem jMOptions;
    private JMenuItem jMQuit;
    private JMenu jMenu4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPopupMenu.Separator jSeparator1;
    private JMenuBar menubar;
    private ViewerPanel viewerPanel;

    public SingleWin(Root root, final String file_name) {
        super(root, file_name != null ? root.MlM(root.getAppTitle()) + ": " + file_name : root.getAppTitle());
        this.initComponents();
        last_path = root.getSetup().getLocalConfig("LastPath", "");
        this.viewerPanel.setRoot(root, (BaseDialogBase)this);
        this.viewerPanel.setopenNewMailInterface(this);
        if (file_name != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (file_name.toLowerCase().endsWith(".msg")) {
                        SingleWin.this.jMNav.setEnabled(true);
                    } else {
                        SingleWin.this.jMNav.setEnabled(false);
                    }
                    SingleWin.this.viewerPanel.parse(file_name);
                }
            });
        } else {
            this.viewerPanel.getHeaderPane().setText(this.MlM("Drag a msg file into this window"));
        }
        this.registerActionKeyListener(KeyStroke.getKeyStroke(78, 0), new Runnable(){

            @Override
            public void run() {
                if (SingleWin.this.jMNav.isEnabled()) {
                    SingleWin.this.jMNavActionPerformed(null);
                }
            }
        });
        new EditorDropTarget(this, this.viewerPanel.getHeaderPane());
        new EditorDropTarget(this, this.viewerPanel.getBodyPane());
    }

    public String getUniqueDialogIdentifier(Object requester) {
        if (this.dialog_id == null) {
            this.dialog_id = super.getUniqueDialogIdentifier(requester);
        }
        return this.dialog_id;
    }

    void cleanUp() {
    }

    public void close() {
        this.cleanUp();
        if (last_path != null) {
            this.root.getSetup().setLocalConfig("LastPath", last_path);
        }
        super.close();
    }

    private void initComponents() {
        this.viewerPanel = new ViewerPanel();
        this.menubar = new JMenuBar();
        this.jMFileOpen = new JMenu();
        this.jFileOpen = new JMenuItem();
        this.jMFileSave = new JMenuItem();
        this.jMOptions = new JMenuItem();
        this.jMQuit = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.jMenuItem5 = new JMenuItem();
        this.jMNav = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.jMFileOpen.setText("Program");
        this.jFileOpen.setText("File Open ...");
        this.jFileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleWin.this.jFileOpenActionPerformed(evt);
            }
        });
        this.jMFileOpen.add(this.jFileOpen);
        this.jMFileSave.setText("Save File as ...");
        this.jMFileSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleWin.this.jMFileSaveActionPerformed(evt);
            }
        });
        this.jMFileOpen.add(this.jMFileSave);
        this.jMOptions.setText("Options");
        this.jMOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleWin.this.jMOptionsActionPerformed(evt);
            }
        });
        this.jMFileOpen.add(this.jMOptions);
        this.jMQuit.setText("Quit");
        this.jMQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleWin.this.jMQuitActionPerformed(evt);
            }
        });
        this.jMFileOpen.add(this.jMQuit);
        this.menubar.add(this.jMFileOpen);
        this.jMenu4.setText("Info");
        this.jMenuItem5.setText("Details");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleWin.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jMenuItem5);
        this.jMNav.setText("MSG Navigator");
        this.jMNav.setEnabled(false);
        this.jMNav.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleWin.this.jMNavActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jMNav);
        this.jMenu4.add(this.jSeparator1);
        this.jMenuItem7.setText("About");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleWin.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jMenuItem7);
        this.jMenuItem8.setText("Changelog");
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleWin.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jMenuItem8);
        this.jMenuItem9.setText("Plugins");
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleWin.this.jMenuItem9ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jMenuItem9);
        this.menubar.add(this.jMenu4);
        this.setJMenuBar(this.menubar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.viewerPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.viewerPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.pack();
    }

    private void jMQuitActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void jMOptionsActionPerformed(ActionEvent evt) {
        this.invokeDialogUnique((BaseDialogBase)new LocalConfig(this.root));
    }

    private void jFileOpenActionPerformed(ActionEvent evt) {
        File[] files;
        int retval;
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new MSGFileFilter(this.root));
        fc.setMultiSelectionEnabled(true);
        logger.info((Object)("last path: " + last_path));
        if (last_path != null) {
            fc.setCurrentDirectory(new File(last_path));
        }
        if ((retval = fc.showOpenDialog((Component)((Object)this))) != 0) {
            return;
        }
        for (File file : files = fc.getSelectedFiles()) {
            last_path = file.getPath();
            this.loadMessage(file.getPath());
        }
    }

    private void jMFileSaveActionPerformed(ActionEvent evt) {
        int retval;
        final JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        final FileNameExtensionFilter msg_filter = new FileNameExtensionFilter(this.MlM("Outlook *.msg File"), "msg");
        FileNameExtensionFilter mbox_filter = new FileNameExtensionFilter(this.MlM("Unix *.mbox File"), "mbox");
        final FileNameExtensionFilter eml_filter = new FileNameExtensionFilter(this.MlM("Thunderbird *.eml File"), "eml");
        fc.addChoosableFileFilter(msg_filter);
        fc.addChoosableFileFilter(mbox_filter);
        fc.addChoosableFileFilter(eml_filter);
        fc.setMultiSelectionEnabled(false);
        if (last_path != null) {
            fc.setCurrentDirectory(new File(last_path));
        }
        if ((retval = fc.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        final File file = fc.getSelectedFile();
        new AutoMBox(this.getClass().getName()){

            public void do_stuff() throws Exception {
                File export_file = file;
                last_path = file.getPath();
                if (!(file.getName().toLowerCase().endsWith(".msg") || file.getName().toLowerCase().endsWith(".eml") || file.getName().toLowerCase().endsWith(".mbox"))) {
                    export_file = fc.getFileFilter() == msg_filter ? new File(file.getAbsolutePath() + ".msg") : (fc.getFileFilter() == eml_filter ? new File(file.getAbsolutePath() + ".eml") : new File(file.getAbsolutePath() + ".mbox"));
                }
                SingleWin.this.viewerPanel.exportFile(export_file);
            }
        };
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        this.invokeDialogUnique((BaseDialogBase)new About(this.root));
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        this.invokeDialogUnique((BaseDialogBase)new LocalHelpWin(this.root, "ChangeLog"));
    }

    private void jMenuItem9ActionPerformed(ActionEvent evt) {
        this.invokeDialogUnique((BaseDialogBase)new AboutPlugins(this.root));
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        if (this.viewerPanel.getMessage() != null) {
            this.invokeDialogUnique((BaseDialogBase)new Internals(this.root, this.viewerPanel.getMessage()));
        }
    }

    private void jMNavActionPerformed(ActionEvent evt) {
        this.invokeDialogUnique((BaseDialogBase)new MSGNavigator(this.root, new File(this.viewerPanel.getFileName())));
    }

    @Override
    public void loadMessage(String file_name) {
        logger.info((Object)("filename: " + file_name));
        if (file_name.startsWith("file://")) {
            try {
                file_name = URLDecoder.decode(file_name, "UTF-8");
                file_name = file_name.substring(7);
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Object)StringUtils.exceptionToString((Exception)ex));
                file_name = file_name.substring(7);
            }
        }
        if (file_name.toLowerCase().endsWith(".msg")) {
            this.jMNav.setEnabled(true);
        } else {
            this.jMNav.setEnabled(false);
        }
        if (this.viewerPanel.getMessage() == null) {
            this.viewerPanel.parse(file_name);
        } else {
            SingleWin win = new SingleWin(this.root, file_name);
            if (!this.menubar.isVisible()) {
                win.hideMenuBar();
            }
            this.invokeMainDialog((BaseDialogBase)win);
        }
    }

    @Override
    public void openMail(Root root, String file) {
        SingleWin win = new SingleWin(root, file);
        if (!this.menubar.isVisible()) {
            win.hideMenuBar();
        }
        this.invokeDialog(win);
    }

    @Override
    public void hideMenuBar() {
        this.menubar.setVisible(false);
    }
}

