/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.factory.mbox;

import at.redeye.FrameWork.utilities.StringUtils;
import com.auxilii.msgparser.Message;
import com.auxilii.msgparser.attachment.Attachment;
import com.auxilii.msgparser.attachment.FileAttachment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import net.sourceforge.MSGViewer.factory.mbox.headers.DateHeader;
import net.sourceforge.MSGViewer.factory.mbox.headers.FromEmailHeader;
import net.sourceforge.MSGViewer.factory.mbox.headers.ToEmailHeader;
import org.apache.log4j.Logger;

public class JavaMailParser {
    private static final Logger logger = Logger.getLogger((String)JavaMailParser.class.getName());
    static final FromEmailHeader from_parser = new FromEmailHeader();
    static final ToEmailHeader to_parser = new ToEmailHeader();
    static final DateHeader date_parser = new DateHeader();

    public Message parse(File file) throws IOException, Exception {
        Session session = Session.getInstance((Properties)System.getProperties());
        MimeMessage jmsg = new MimeMessage(session, (InputStream)new FileInputStream(file));
        Message msg = new Message();
        from_parser.parse(msg, JavaMailParser.getAddresses(jmsg.getFrom()));
        to_parser.parse(msg, JavaMailParser.getAddresses(jmsg.getFrom()));
        msg.setSubject(jmsg.getSubject());
        msg.setHeaders(this.getHeaders(jmsg.getAllHeaders()));
        date_parser.parse(msg, this.getFirstHeader(jmsg.getHeader("Date")));
        msg.setMessageId(this.getFirstHeader(jmsg.getHeader("Message-Id")));
        String content_type_string = jmsg.getContentType();
        msg.setBodyText("");
        msg.setBodyRTF("");
        this.parse(msg, (Part)jmsg);
        return msg;
    }

    private void parse(Message msg, Part part) throws MessagingException, IOException {
        logger.info((Object)("Content Type: " + part.getContentType()));
        if (part.isMimeType("text/plain") && msg.getBodyText().isEmpty()) {
            msg.setBodyText((String)part.getContent());
        } else if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart sub_part = multipart.getBodyPart(i);
                this.parse(msg, (Part)sub_part);
            }
        } else {
            String disp = part.getDisposition();
            if (disp == null && part.getFileName() == null && part.isMimeType("text/html")) {
                byte[] bytes = this.getContent((MimeBodyPart)part);
                StringBuilder sb = new StringBuilder();
                sb.append(new String(bytes, this.getCharset(part.getContentType())));
                sb.append("<!-- \\purehtml -->");
                msg.setBodyRTF(sb.toString());
                logger.debug((Object)msg.getBodyRTF());
                return;
            }
            if (disp == null || disp.equalsIgnoreCase("attachment")) {
                MimeBodyPart mpart = (MimeBodyPart)part;
                FileAttachment att = new FileAttachment();
                att.setMimeTag(this.getMime(part.getContentType()));
                att.setFilename(part.getFileName());
                String cid = mpart.getContentID();
                if (cid != null) {
                    cid = StringUtils.strip((String)cid, (String)"<>");
                    att.setCid(cid);
                }
                att.setSize((long)mpart.getSize());
                if (att.getFilename() == null) {
                    att.setFilename("");
                }
                att.setData(this.getContent((MimeBodyPart)part));
                msg.addAttachment((Attachment)att);
            }
        }
    }

    private String getCharset(String content) {
        if (content.matches(".*;\\s*charset=.*")) {
            int idx = content.indexOf("=");
            String charset = content.substring(idx + 1);
            byte[] c = new byte[]{32, 0};
            charset = StringUtils.strip((String)charset, (String)"\"");
            try {
                String string = new String(c, charset);
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Object)("Invalid encoding: " + content + "=>'" + charset + "'"), (Throwable)ex);
                return "ASCII";
            }
            return charset;
        }
        return "ASCII";
    }

    private byte[] getContent(MimeBodyPart mp) throws IOException, MessagingException {
        int len;
        InputStream in = mp.getInputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((len = in.read(bytes)) > 0) {
            bos.write(bytes, 0, len);
        }
        byte[] ba = bos.toByteArray();
        return ba;
    }

    private String getMime(String content_type) {
        int idx = content_type.indexOf("\n");
        if (idx < 0) {
            return content_type;
        }
        String mime = content_type.substring(0, idx).trim();
        return StringUtils.strip_post((String)mime, (String)";");
    }

    private String getFirstHeader(String[] headers) {
        if (headers == null) {
            return "";
        }
        return headers[0];
    }

    private static String getAddresses(Address[] addresses) {
        if (addresses == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Address addr : addresses) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(addr.toString());
        }
        return sb.toString();
    }

    private String getHeaders(Enumeration allHeaders) {
        StringBuilder sb = new StringBuilder();
        while (allHeaders.hasMoreElements()) {
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            Object o = allHeaders.nextElement();
            Header h = (Header)o;
            sb.append(h.getName());
            sb.append(": ");
            sb.append(h.getValue());
        }
        return sb.toString();
    }
}

