/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.factory.msg.entries;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.MSGViewer.factory.msg.PropTypes.PropType;
import org.apache.poi.poifs.filesystem.DirectoryEntry;

public abstract class SubstGEntry {
    public static final String TYPE_ASCII = "001e";
    public static final String TYPE_UTF16 = "001f";
    public static final String TYPE_BYTES = "0102";
    String type;
    String name;

    public SubstGEntry(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public void createEntry(DirectoryEntry dir, String value) throws IOException {
        ByteArrayInputStream in = null;
        if (this.type.equals(TYPE_ASCII)) {
            in = new ByteArrayInputStream(value.getBytes("ISO-8859-1"));
        } else if (this.type.equals(TYPE_UTF16)) {
            in = new ByteArrayInputStream(value.getBytes("UTF-16LE"));
        }
        dir.createDocument("__substg1.0_" + this.name + this.type.toUpperCase(), (InputStream)in);
    }

    public void createEntry(DirectoryEntry dir, byte[] value) throws IOException {
        ByteArrayInputStream in = null;
        if (this.type.equals(TYPE_BYTES)) {
            in = new ByteArrayInputStream(value);
        }
        dir.createDocument("__substg1.0_" + this.name + this.type.toUpperCase(), (InputStream)in);
    }

    public static void createBinaryNullEntry(DirectoryEntry dir, String name, String type, int len) throws IOException {
        ByteArrayInputStream in = null;
        in = new ByteArrayInputStream(new byte[len]);
        dir.createDocument("__substg1.0_" + name + type.toUpperCase(), (InputStream)in);
    }

    public String getTypeName() {
        return this.type;
    }

    public String getTagName() {
        return this.name;
    }

    public String toString() {
        return this.name + this.type;
    }

    public abstract PropType getPropType();

    public abstract void createEntry(DirectoryEntry var1) throws IOException;
}

