/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package at.redeye.FrameWork.utilities.calendar;

import java.util.Collection;
import java.util.Vector;
import org.joda.time.DateMidnight;

import at.redeye.FrameWork.utilities.calendar.Holidays.HolidayInfo;
import org.joda.time.LocalDate;

/**
 *
 * @author Administrator
 */
public class GermanHolidays extends BaseHolidays implements Holidays {

    public static String myCountryCode = "DE";
    
    public GermanHolidays()
    {
        super(myCountryCode);

        root.loadMlM4Class(this, "de");
    }
    
    public Collection<HolidayInfo> getHolidays(int year) {
        
        // siehe http://de.wikipedia.org/wiki/Feiertage_in_Deutschland
        Vector<HolidayInfo> res = new Vector<HolidayInfo>();                                                       
        
        Easterformular easter_formular = new Easterformular(year);
                
        int day = easter_formular.easterday();
                
        LocalDate easter = getEaster(year);
                
        res.add( create( easter, true, true, "Ostersonntag" ) );
              
        
        res.add( create( year, 1, 1, false, true, "Neujahrstag" ) );
        res.add( create( year, 1, 6, false, false, "Dreikönigstag" ) );

        LocalDate gruendonnerstag = easter.minusDays(3);
        res.add( create( gruendonnerstag, true, false, "Gründonnerstag"));

        LocalDate karfreitag = easter.minusDays(2);
        res.add( create( karfreitag, true, true, "Karfreitag"));                
        
        LocalDate ostermontag = easter.plusDays(1);
        res.add( create( ostermontag, true, true, "Ostermontag"));
        
        res.add( create( year, 5, 1, false, true, "Tag der Arbeit" ) );        

        LocalDate christihimmelfahrt = easter.plusDays(39);
        res.add( create( christihimmelfahrt, true, true, "Christi Himmelfahrt"));

        LocalDate aschermittwoch = easter.minusDays(46);
        res.add( create( aschermittwoch, true, false, "Aschermittwoch"));

        LocalDate faschingdienstag = easter.minusDays(47);
        res.add( create( faschingdienstag, true, false, "Faschingdienstag"));        

        LocalDate rosenmontag = easter.minusDays(48);
        res.add( create( rosenmontag, true, false, "Rosenmontag"));        
        
        LocalDate pfingsten = easter.plusDays(49);
        res.add( create( pfingsten, true, false, "Pfingsten"));

        LocalDate pfingstmontag = easter.plusDays(50);
        res.add( create( pfingstmontag, true, true, "Pfingstmontag"));        
        
        LocalDate fronleichnam = easter.plusDays(60);
        res.add( create( fronleichnam, true, false, "Fronleichnam"));
        
        res.add( create( year, 8, 15, false, false, "Maria Himmelfahrt" ) );
        
        res.add( create( year, 10, 3, false, true, "Tag der Deutschen Einheit" ) );
        
        res.add( create( year, 10, 31, false, false, "Reformationstag" ) );
        
        res.add( create( year, 11, 1, false, false, "Allerheiligen" ) );        
        res.add( create( year, 11, 2, false, false, "Allerseelen" ) );
        
        res.add( create( year, 12, 25, false, true, "1. Weihnachtsfeiertag" ) );
        res.add( create( year, 12, 26, false, true, "2. Weihnachtsfeiertag" ) );        
                
        res.add( create( getEuropeanSummerTimeBegin(year), true, false, "Sommerzeit Beginn" ));
        res.add( create( getEuropeanSummerTimeEnd(year), true, false, "Ende Sommerzeit" ));
        
        return res;        
    }

    public String getPrimaryCountryCode() {
        return myCountryCode;
    }

}
